


/*******************************************************************************************
 *                                                                                         *
 *        Examples :  RTC+TEMP Sensor  For "CP-JR51RD2" Board                              *
 *                                                                                         * 
 *                 :  Interface I2C (Use I/O Pin)                                          *
 *                                                                                         *
 *******************************************************************************************
 *                                                                                         *
 * Target MCU     : ATMEL AT89C51ED2,RD2                                                   *
 *       	      : X-TAL : 18.432 MHz (6-Clock Mode)                                      * 
 *                                                                                         *
 * Editor         : uVision3 (V3.62c)                                                      *
 * Compiler       : Keil C51 (V8.05 a)                                                     *
 * Create By      : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                   *
 * Last Update    : 17/December/2011                                                       *
 *                                                                                         *
 * DS3232         : Interface I2C(ID:1101000X = 0xD0(Wr),0xD1(Rd) )                        * 
 *																				           *
 * Port Interface :  																	   *
 *          								                                               *
 *             LCD:      																   *
 *                       P0.1 = RS(out)                                                    *
 *                       P0.2 = R/W(out)                                                   *
 *                       P0.3 = E(Out)                                                     *
 *                       P0.4-P0.7 = Data 4 bit high(Out)                                  *
 *                                                                                         *
 *                                                                                         *
 *       5V                                                                                *
 *      --+--                                                                              *
 *        |                                                                                *
 *        +-----------------+                                                              *
 *        |                 |                                                              *
 *       ---                |                                                              *
 *       |\|                |                                                              *
 *    VR |/|<---------------|--+                                                           *
 *   10K ---                |  | P0.1 P0.2 P0.3        P0.4 P0.5 P0.6 P0.7                 *
 *        |                 |  |   ^   ^   ^              ^   ^   ^   ^                    *
 *        |                 |  |   |   |   |              |   |   |   |                    *
 *        +--------------+--|--|---|---|---|--+--+--+--+  |   |   |   |                    *
 *      __|__            |  |  |   |   |   |  |  |  |  |  |   |   |   |                    *
 *       ---             |  |  |   |   |   |  |  |  |  |  |   |   |   |                    *
 *        -             1| 2| 3|  4|  5| 6 | 7| 8| 9|10|11|12 | 13| 14|                    *
 *                     __|__|__|___|___|___|__|__|__|__|__|___|___|___|_                   *
 *                    |  G Vcc Vo RS  R/W  E  D0 D1 D2 D3 D4  D5  D6 D7 |                  *
 *                    |    _________________________________________    |                  *
 *                    |   |                                         |   |                  *
 *                    |   |               Module                    |   |                  *
 *                    |   |         LCD 2x16 Charecter              |   |                  *  
 *                    |   |_________________________________________|   |                  *
 *                    |                                                 |                  *
 *                    |_________________________________________________|                  *
 *                                                                                         *     
 *																						   *
 *		 I2C:																			   *
 *                    -- MCU-AT89C51ED2--	  	  	     -- Mini-DS3232 Module --          * 																				       *
 *             				                                                               *
 *                     P1.6 (SCK-out)	   Connect 		    SCL(Clock) 		               *
 *                     P1.7 (SDA-I/O)	   Connect 		    SDA(DATA)    	               *
 *                                                                                         *
 * Operat: Test RTC and Temp ON LCD and Alarm On Buzzer                                    *  
 *                                                                                         *
 *******************************************************************************************/


						
#include <89c51rd2.h>
#include <stdio.h>



//----------------- Define I2C Pin ------------------

#define     SCK_HI()    P1_6 = 1 	//P1.6=SCK:1
#define     SCK_LO()    P1_6 = 0 	//P1.6=SCK:0

#define     SDA_HI()    P1_7 = 1    //P1.7=SDA:1 
#define     SDA_LO()    P1_7 = 0 	//P1.7=SDA:0

//----------LCD ---------

sbit   Ena = P0^3        ;  //Refferent Bit0.3 = Ena

//---- I2C -------
sbit  SDA = P1^7         ;  //Refferent Bit1.7 = SDA
	   

int ss,mn,hh,tem,dot,dd,mm,yy     ;
char sign                         ;

/**********************************************************
 **                    Function Delay                    **
 **********************************************************/

  void delay(int cnt)
   {
     int i,j ;
      for(i=0;i<cnt;i++)
        for(j=0;j<cnt;j++) ;
   }


/*----------------------------------------------------------------
  -                       FUNCTION LCD                   		 -
  ----------------------------------------------------------------*/

/**********************************
 *    write instruction LCD       *
 **********************************/

void write_cmm(unsigned char cmm)
{
  
  P0 = cmm & 0xF0           ;	 //Sent cmm 4 bit High,RS:P0.1 = 0 ,RW:P0.2=0
  Ena = 1                   ;    
  delay(6)                  ;
  Ena = 0                   ;    
  delay(6)                  ;

  P0 = (cmm << 4) & 0xF0    ;  //Sent cmm 4 bit Low,RS:P0.1 = 0,RW:P0.2=0
  Ena = 1                   ;   
  delay(6)                  ;
  Ena = 0                   ;   
  delay(6)                  ;
}



/*********************************
 *       write data lcd          *
 *********************************/

void write_data(unsigned char dat)
{ 
  P0 = (dat & 0xF0) | 0x02           ;	  //Sent cmm 4 bit High,RS:P0.1 =1 ,RW:P0.2=0
  Ena = 1                            ;    
 delay(6)                            ;
  Ena = 0                            ;    
  delay(6)                           ;

  P0 = ((dat << 4) & 0xF0) | 0x02    ;	 //Sent cmm 4 bit Low,RS:P0.1 =1 ,RW:P0.2=0
  Ena = 1                            ;    
  delay(6)                           ;
  Ena = 0                            ;    
  delay(6)                           ;

}

/******************************
 *      Clear Display LCD     *
 ******************************/

void clr_display(void)
 {
  write_cmm(0x01) ;
 }


/**********************************
 *          initial lcd           *
 **********************************/
void init_lcd(void)
{
  write_cmm(0x33);	        //Command Control 
  write_cmm(0x32);
  write_cmm(0x28);
  write_cmm(0x0C);  	    //Set Display On/Off:Display On,Not Show Cursor and not blink Cursor
  write_cmm(0x06);  	    //Set Entry Mode :Increment Address,Cursor Shift Right

    
  write_cmm(0x1C);          //Set Cursor Or Display Shift : Shift Right Charecter
  write_cmm(0x28);      	//Function Set: set interface data 4bit,Set Display LCD 2 Line ,Set Charecter Size 5x7
  write_cmm(0x80|0x00);		//Set Address Begin 0x00 (Line1 Charecter1)
  clr_display();
}




/**************************************************************
 *			    	Convert BCD Time to ascii		    	  *
 **************************************************************/

 void conv_time(char sec,char min,char hour)
 {
  
   //---------- Convert Second(00-59) to ascii ---------
   ss = sec >> 4             ;
   ss = ss+0x30  		     ; //Secound byte High to ascii

   sec = sec & 0x0F          ;
   sec = sec+0x30            ; //Secound byte Low to ascii
   ss = (ss << 8)| sec       ; 

   //---------- Convert Minute(00-59) to ascii ---------

   mn = min >> 4             ;
   mn = mn+0x30  		     ;  //Minuted byte High to ascii

   min = min & 0x0F          ;
   min = min+0x30            ;  //Minuted byte Low to ascii
   mn = (mn << 8)| min       ; 

   //---------- Convert Hour(00-23) to ascii ---------

   hh = hour >> 4            ;  //Hour byte High to ascii
   hh = hh+0x30  		     ;

   hour = hour & 0x0F        ;
   hour = hour+0x30          ;  //Hour byte Low to ascii
   hh   = (hh << 8)| hour    ; 

 }

 
/**************************************************************
 *			 	Convert BCD DATE to ascii		              *
 **************************************************************/

 void conv_date(char date,char month,char year)
 {
  
   //---------- Convert date(00-31) to ascii ---------
   dd = date >> 4               ;
   dd = dd+0x30  		        ; //Date byte High to ascii

   date = date & 0x0F           ;
   date = date+0x30             ; //Date byte Low to ascii
   dd   = (dd << 8)| date       ; 

   //---------- Convert Month(00-12) to ascii ---------

   mm = (month >> 4)& 0x07       ;  //Clear bit Century
   mm = mm+0x30  		         ;  //Month byte High to ascii

   month = month & 0x0F          ;
   month = month+0x30            ;  //Month byte Low to ascii
   mm    = (mm << 8)| month      ; 

   //---------- Convert Year(00-99) to ascii ---------

   yy = year >> 4            ;  //Year byte High to ascii
   yy = yy+0x30  		     ;

   year = year & 0x0F        ;
   year = year+0x30          ;  //Year byte Low to ascii
   yy   = (yy << 8)| year    ; 

 }
 
/**************************************************************
 *				 Convert hex Temp to ascii		              *
 **************************************************************/
void conv_temp(signed char tm,unsigned char tf)
{

  //------------- Sign to ascii -------------
	if(tm & 0x80)
	  sign = '-'                        ;	   //Temp- show sign '-'
    else
	  sign = 0x20                       ;	   //Temp+ show sign space

  //------------- Temp. Integer hex to ascii -------------

    tm  = tm & 0x7F                     ;      //Clear bit sign
    tem = (tm/10)+0x30	                ;      //Keep Temp byte high to Ascii     
	tem = (tem <<8)|((tm%10)+0x30)      ;	   //Keep Temp byte Low to Ascii 
 
  //------------- Temp.(Step=0.25C) fractional hex to ascii -------------

  	tf  = tf >>6                        ;     //Shift data bit 7..6  to bit  1..0    
	tf  = tf*25                         ;     //Step temp 25
	dot = (tf/10)+0x30                  ;     //hex to Ascii byte High
	dot = (dot<<8)|((tf%10)+0x30)       ; 	  //hex to Ascii byte Low
} 



/*-------------------------------------------------------------------------
  -                             FUNCTION I2C                              -
  -------------------------------------------------------------------------*/

//----------------- I2C Start ------------------
void I2C_start()
{

   SDA_HI()              ;	//I2C Start Condition					
   SCK_HI()              ;
   SDA_LO()              ;					
   SCK_LO()              ;

}

//---------------- I2C Stop -----------------

void I2C_stop()
{
   SDA_LO()              ;	//I2C Stop Condition					  
   SCK_HI()              ;
   SDA_HI()              ;		
}


/***********************************************************************************
 **                       Function I2C Write 8bit Data                            **
 **                                                                               **
 **  Parameter : dat = data for DS3232 (1Byte)                                    **
 **                                                                               **       
 ***********************************************************************************/

void I2C_WrByte(char dat)			  	
{
   char loop ;		

   for(loop =0;loop<8;loop++)       //Loop Write data 8-Bit
    {
     if((dat & 0x80)==0x80) 		//Check Data bit8 is '0' or '1'? 
       SDA_HI()                  ;	//If data is '1' Set Pin P1.7(SDA) = 1
     else                   
       SDA_LO()                  ;  //if data is '0' Set Pin P1.7(SDA) = 0

     SCK_HI()                    ;  //Clock HI
     SCK_LO()                    ;  //Clock LO
  
     dat <<= 1                   ;  //Shift Left Data For Send (MSB <- LSB)
   }

   SDA_HI()                      ;  //Release SDA
   SCK_HI()                      ;  //Start ACK Clock
   while(SDA&0x01){;}               //Check ACK:P1.7 = 0 Out Loop
   SCK_LO()                      ;  //End ACK Clock

}


/************************************************************************ 
 **                        Function Write RTC(DS3232)                  **
 ** Parameter :                                                        **
 **            addr  = Address  Register for write(1Byte)              **
 **            dat   = Data for Set up DS3232(1Byte)                   **                      
 ************************************************************************/
 
void I2C_WrRTC (char addr,signed char dat)
{ 
  
   I2C_start()           ;	//I2C Start Condition					
  
//---------- Sent Slave address for Write ---------------

   I2C_WrByte(0xD0)      ;  //Send ID Code DS3232+Write (1101 000+0)

//--------- Sent address Register  ----------------

   I2C_WrByte(addr)      ;	//Send Address Reg. to DS3232
  
//------------- Sent data to RTC 1 byte ---------------

   I2C_WrByte(dat)       ;	//Send Data Control to DS3232
 
//------------ Sent Status Stop Write---------------  

   I2C_stop();
  
}

 
/******************************************************************
 **                 Function I2C Read  8 bit Data                **  
 **                                                              **       
 ******************************************************************/

 signed char I2C_RdByte(void)			  	
 { 
   char loop,result=0 ;		
    
  	
   for(loop = 0; loop < 8; loop++)	   //Loop Read data 8-Bit
    {
      result <<= 1                 ;   //Shift Result Save (MSB <- LSB)   

	  SDA_HI()                     ;   //Release Data	
	  SCK_HI()                     ;   //Strobe Read SDA	
      if((SDA&0x01) == 0x01)           //Check Data Read Pin SDA(P1.7) is '0' or '1'
	    result |= 0x01             ;   //If Read Pin SDA is '1' Give Save Bit Data = 1
      SCK_LO()                     ;   //Next Bit Read

    } 

 return result                    ;

}

 
/*************************************************************
 **              Function Read RTC(DS3232) 1 Byte           **
 ** Parameter :                                             **
 **              addr = Register Address for Read            **
 *************************************************************/

 signed char I2C_RdRTC(char addr)
  {
    char dat  ;
   
//-------------- Sent Status Start for write -----------

   I2C_start()              ; 			 	  //I2C Stat condition
  
//------------- Sent Slave Address for Write------------	
 
   I2C_WrByte(0xD0)        ;				 //Send ID Code DS3232,Write (1101 000+0)

//------------ Sent address Register --------------

   I2C_WrByte(addr)       ;					//Send Address Reg. to DS3232


//---------- New Sent Status Start For Read ----------

   I2C_start()            ;					//I2C Stat condition
  
//-------------Sent Slave address for Read ------------

   I2C_WrByte(0xD1)       ;					//Send ID Code DS3232 ,Write (1101 000+1)
  
//------------- Read data 1 Byte ------------
   
   dat = I2C_RdByte()     ;					//Read Data 1-Byte From DS3232 
  
//---------- Sent Status Stop Red ---------------
   I2C_stop()             ; 				//I2C Stop Condition
 

	return dat            ;                 //Return Data
  }




 /*##########################################################################
   ##                           Main Program                               ##
   ##########################################################################*/

 void main(void)
  {   
    char sec,min,hor,tf,date,month,year ;
	signed char tp      ;
	int n   ;

  //CKCON    = 0xFE ;      //Select 12 clk Mode,X2=0
    CKCON    = 0x01 ;      //Select 6 clk Mode,X2=1
	AUXR     = 0x10 ;      //Set XRAM = 1792 Byte

	Ena = 0			;      //Clear pin Enable LCD
	init_lcd()      ;
    delay(100)      ;	

//------------ write string to lcd ----------------
  
  //----------- String mode Time ----------

   write_cmm(0x80|0x00)    ;  //Start address lcd = 0x00  Line 1
   write_data('T')         ;  //Plot data to lcd
   write_data('i')         ;
   write_data('m')         ;
   write_data('e')         ;
   write_data(':')         ;
   write_cmm(0x80|0x07)    ;  //Start address lcd = 0x07  Line 1
   write_data(':')         ;
   write_cmm(0x80|0x0A)    ;  //Start address lcd = 0x0A  Line 1
   write_data(':')         ;

 
 
   delay(100);
 
 
//--------- Set Time Secound:Minute:Hour to DS3232-------------

   I2C_WrRTC(0x00,0x00)    ;  //Write Second
   I2C_WrRTC(0x01,0x00)    ;  //Write minute
   I2C_WrRTC(0x02,0x12)    ;  //Write Hour


    
//--------- Set Date Date:Month:Year to DS3232-------------

   I2C_WrRTC(0x04,0x01)    ;  //Write Date
   I2C_WrRTC(0x05,0x01)    ;  //Write Month
   I2C_WrRTC(0x06,0x12)    ;  //Write year
  
  while(1)
  {

//--------------------- Display Time & Temp ----------------------

    //----------- String mode Temp ----------

   write_cmm(0x80|0x40)    ;  //Start address lcd = 0x40 Line 2
   write_data('T')         ;  //Plot data to lcd
   write_data('e')         ;
   write_data('m')         ;
   write_data('p')         ;
   write_data(':')         ;
   write_cmm(0x80|0x45)    ;  //Start address lcd = 0x45 Line 2
   write_data(0x20)        ;  //Plot data to lcd for sige -
   
   write_cmm(0x80|0x48)    ;  //Start address lcd = 0x48 Line 2
   write_data('.')         ;  //Plot data to lcd
 

   write_cmm(0x80|0x4B)    ;  //Start address lcd = 0x4B Line 2
   write_data(0xD2)        ;  //Plot data to lcd
   write_data('C')         ;  //Plot data to lcd
   

    for(n=0;n<1000;n++)
	 {

 //------------ Read Time ss:mm:hh from ds3232 --------------

	sec = I2C_RdRTC(0x00)          ;  //Read Second
    min = I2C_RdRTC(0x01)          ;  //Read minute
	hor = I2C_RdRTC(0x02)          ;  //Read Hour  24 Hour
	conv_time(sec,min,hor)         ;  //Convert sec:min:hor to ascii

//------------ Read Temp from ds3232 --------------
	tp = I2C_RdRTC(0x11)           ;  //Read interger + sige temp. 
    tf = I2C_RdRTC(0x12)           ;  //Read fractional(step =0.25 C) temp.
	conv_temp(tp,tf)               ;


//------------ Write Data hh:mm:ss to LCD -------------

	write_cmm(0x80|0x05)    ;  //Start address lcd = 0x05
    write_data(hh>>8)       ;
	write_data(hh)          ;
	
	write_cmm(0x80|0x08)    ;  //Start address lcd = 0x08
    write_data(mn>>8)       ;
	write_data(mn)          ;

	write_cmm(0x80|0x0B)    ;  //Start address lcd = 0x0B
    write_data(ss>>8)       ;
	write_data(ss)          ;

//------------ Write Data Temp to LCD -------------

  	write_cmm(0x80|0x45)    ;  //Start address lcd = 0x48
    write_data(sign)        ;  // data Sign

    write_data(tem>>8)      ;  //data integer Temp
	write_data(tem)         ;

	write_cmm(0x80|0x49)    ;  //Start address lcd = 0x4B
    write_data(dot>>8)      ;  //data Fractional Temp
	write_data(dot)         ;
  
   }


  //-----------------Display Time & Date ------------------


	 //----------- String mode Date ----------

   write_cmm(0x80|0x40)    ;  //Start address lcd = 0x40 Line 2
   write_data('D')         ;  //Plot data to lcd
   write_data('a')         ;
   write_data('t')         ;
   write_data('e')         ;
   write_data(':')         ;
   write_cmm(0x80|0x47)    ;  //Start address lcd = 0x47 Line 2
   write_data('/')         ;  //Plot data to lcd for sige -
   
   write_cmm(0x80|0x4A)    ;  //Start address lcd = 0x4A Line 2
   write_data('/')         ;  //Plot data to lcd


   for(n=0;n<1000;n++)
	{

 //------------ Read Time ss:mm:hh from ds3232 --------------

	sec = I2C_RdRTC(0x00)          ;  //Read Second
    min = I2C_RdRTC(0x01)          ;  //Read minute
	hor = I2C_RdRTC(0x02)          ;  //Read Hour  24 Hour
	conv_time(sec,min,hor)         ;  //Convert sec:min:hor to ascii

//------------ Read Date:Mount:Year  from ds3232 --------------
	date  = I2C_RdRTC(0x04)        ;  //Read date (1-31). 
    month = I2C_RdRTC(0x05)        ;  //Read Mount
	year  = I2C_RdRTC(0x06)        ;  //Read year
	conv_date(date,month,year)     ;  //


//------------ Write Data hh:mn:ss to LCD -------------

	write_cmm(0x80|0x05)    ;  //Start address lcd = 0x05
    write_data(hh>>8)       ;
	write_data(hh)          ;
	
	write_cmm(0x80|0x08)    ;  //Start address lcd = 0x08
    write_data(mn>>8)       ;
	write_data(mn)          ;

	write_cmm(0x80|0x0B)    ;  //Start address lcd = 0x0B
    write_data(ss>>8)       ;
	write_data(ss)          ;

//------------ Write Data dd:mm:yy to LCD -------------

  	write_cmm(0x80|0x45)    ;  //Start address lcd = 0x45
    write_data(dd>>8)       ;  //Plot data date
	write_data(dd)          ;

	write_cmm(0x80|0x48)    ;  //Start address lcd = 0x48
    write_data(mm>>8)       ;  //Plot data month
	write_data(mm)          ;
  
    write_cmm(0x80|0x4B)    ;  //Start address lcd = 0x4B
    write_data(yy>>8)       ;  //Plot data year
	write_data(yy)          ;
   
   }
 }
}
